/**
 * Callback Handler - Auto-detect and save token from callback page
 */

// Only run on callback page
if (window.location.href.includes('journament.com/extension/callback')) {

    // Wait for page to fully load
    window.addEventListener('load', () => {
        // Extract token from the page
        const tokenInput = document.getElementById('apiToken');

        if (tokenInput && tokenInput.value) {
            const token = tokenInput.value;

            // Send token to background script
            chrome.runtime.sendMessage({
                action: 'saveToken',
                token: token
            }, (response) => {
                if (response && response.success) {

                    // Show success notification on page
                    const container = document.querySelector('.container');
                    if (container) {
                        const successDiv = document.createElement('div');
                        successDiv.className = 'alert alert-success mt-3';
                        successDiv.innerHTML = `
                            <i class="fas fa-check-circle me-2"></i>
                            <strong>Extension Authenticated!</strong>
                            You can now close this window and start using the extension.
                            <button type="button" class="btn-close float-end" onclick="window.close()"></button>
                        `;
                        container.insertBefore(successDiv, container.firstChild);

                        // Auto-close after 3 seconds
                        setTimeout(() => {
                            window.close();
                        }, 3000);
                    }
                } else {
                    console.error('[Journament] Failed to save token');
                }
            });
        } else {
        }
    });
}
